import unittest

from cad_parser.definitions import Order, Patient, Element

class TestOrder(unittest.TestCase):
    def test_constructor(self):
        order = Order(
            project='foo', 
            format='exocad', 
            patient=Patient(1, 'Mustermann', 'Max'), 
            comment=':(){ :|:& };:', 
            practice_id=1, 
            elements=[
                Element(file_name='foo.stl', material='gold', color='A1', height=7.5, is_screw_retained=None, type='ModelBase', teeth=[])
            ],
            models=[],
            scan_files=[],
            loaded_scene_file=None
        )

        self.assertEqual(order.project, 'foo')
        self.assertEqual(order.format, 'exocad')
        self.assertEqual(order.patient.id, 1)
        self.assertEqual(order.patient.last_name, 'Mustermann')
        self.assertEqual(order.patient.first_name, 'Max')
        self.assertEqual(order.comment, ':(){ :|:& };:')
        self.assertEqual(order.practice_id, 1)
        self.assertEqual(order.elements[0].file_name, 'foo.stl')
        self.assertEqual(order.elements[0].material, 'gold')
        self.assertEqual(order.elements[0].color, 'A1')
        self.assertEqual(order.elements[0].height, 7.5)
        self.assertEqual(order.elements[0].is_screw_retained, None)
        self.assertEqual(order.elements[0].teeth, [])
