from typing import NamedTuple, List

# Output format
class Patient(NamedTuple):
    id: int
    last_name: str
    first_name: str

class Tooth(NamedTuple):
    fdi: int
    color: str
    implant_type: str
    is_anatomical: bool
    type: str

class Element(NamedTuple):
    file_name: str
    material: str
    color: str
    height: float
    is_screw_retained: bool
    type: str
    teeth: List[Tooth]
    
class ScanFile(NamedTuple):
    file_name: str
    type: str

class Order(NamedTuple):
    format: str
    project: str
    patient: Patient
    comment: str
    practice_id: int
    elements: List[Element]
    models: List[Element]
    scan_files: List[ScanFile]
    loaded_scene_file: str
