import unittest

from cad_parser.definitions import Element, Tooth

class TestElement(unittest.TestCase):
    def test_constructor(self):
        teeth = [
            Tooth(1, 'A1', None, None, 'AnatomicCrown'),
            Tooth(2, 'A2', None, None, 'AnatomicCrown')
        ]
        element = Element(file_name='foo.stl', material='gold', color='orange', height=7.838345409284646, is_screw_retained=None, type=None, teeth=teeth)

        self.assertEqual(element.file_name, 'foo.stl')
        self.assertEqual(element.material, 'gold')
        self.assertEqual(element.color, 'orange')
        self.assertAlmostEqual(element.height, 7.838345409284646)
        self.assertEqual(element.is_screw_retained, None)
        
        self.assertEqual(len(element.teeth), 2)

        tooth0 = element.teeth[0]
        self.assertEqual(tooth0.fdi, 1)
        self.assertEqual(tooth0.color, 'A1')
        self.assertEqual(tooth0.implant_type, None)
        self.assertEqual(tooth0.is_anatomical, None)
        self.assertEqual(tooth0.type, 'AnatomicCrown')

        tooth1 = element.teeth[1]
        self.assertEqual(tooth1.fdi, 2)
        self.assertEqual(tooth1.color, 'A2')
        self.assertEqual(tooth1.implant_type, None)
        self.assertEqual(tooth1.is_anatomical, None)
        self.assertEqual(tooth1.type, 'AnatomicCrown')
