import unittest

from pathlib import Path

from cad_parser.hyperdent import is_supported, parse

class SkipTest:
    def __init__(self, condition, description):
        self.condition = condition
        self.description = description

    def __call__(self, func):
        if not self.condition:
            return unittest.skip(self.description)(func)
        return func

@SkipTest(Path('tests/samples/hyperdent').exists(), "Lokal tests only")
class TestHyperdent(unittest.TestCase):
    def test_is_supported(self):
        self.assertTrue(is_supported(Path('tests/samples/hyperdent/09_abutment/180066')))

    def test_parse(self):
        files, order = parse(Path('tests/samples/hyperdent/09_abutment/180066'))
        
        for element in order.elements:
            for tooth in element.teeth:
                if tooth.type == 'abutment':
                    self.assertEqual(tooth.implant_system, 'Abutment_MEG_3.555_GH05')

    def test_filenames(self):
        files, order = parse(Path('tests/samples/hyperdent/09_abutment/180066'))

        for element in order.elements:
            segments = element.file_name.split('/')
            self.assertEqual(len(segments), 1)
            segments = element.file_name.split(r'\\')
            self.assertEqual(len(segments), 1)
            self.assertIn('.stl', element.file_name)