import unittest

from pathlib import Path

from src.millconnect.project import Project

class ExocadProject(unittest.TestCase):

    projectPath = Path('samples/exocad/02_Krone/156094_krone_inkl_Abutment')

    def test_constructor(self):
        with self.assertRaises(FileNotFoundError):
            project = Project(Path('some/bad/path'))
                              
        project = Project(self.projectPath)

    def test_projectFiles(self):
        project = Project(self.projectPath)

        print(project.projectFiles)

    def test_projectOrder(self):
        project = Project(self.projectPath)

        print(project.order)

    def test_untrackedFiles(self):
        project = Project(self.projectPath)
        self.assertTrue(set(project.trackedFiles).isdisjoint(project.untrackedFiles), 'Tracked files cannot contain untracked Files.')
        self.assertTrue(set(project.trackedFiles).issubset(project.filesWithinProjectFolder), 'Tracked files are part of the files of the project.')
        self.assertTrue(set(project.untrackedFiles).issubset(project.filesWithinProjectFolder), 'Untracked files are part of the files of the project.')
        self.assertTrue(project.constructionInfoPath not in set(project.untrackedFiles), 'File .constructionInfo should not be part of untracked files.')
        self.assertTrue(project.dentalProjectPath not in set(project.untrackedFiles), 'File .dentalProject should not be part of untracked files.')
        for file in project.untrackedFiles:
            self.assertEqual(file.suffix, 'stl')


class ThreeShapeProject(unittest.TestCase):
    def test_threeshape(self):
        projectPath = Path('samples/3shape/01_Kappe/24-07-23_Kappen_3ox')
        project = Project(projectPath)
        
        

if __name__ == '__main__':
    unittest.main()