# millCONNECT Client

This is a Python project that provides a client for the millCONNECT frontend and backend. Its main purpose is to provide a convenient way of uploading orders from a local machine to the backend server through the use of a web-based frontend.

## Internal branch
This project in mainly developed on two branches, `master` and `intern`. The `master` branch ist the production environment and is used for customers. The `intern` branch is for internal use, which contains additional features like manual setting of customers for new orders. In order to keep both branches in sync with each other, the `master` branch is merged into `intern` and the `intern` branch uses tags with the suffix `-intern` for versioning.

## Installing
To start using this software, you need to have Python 3 installed on your system. A convenient way of installing this application is the use of the [millCONNECT setup](https://gitlab.millhouse.local/millconnect/millconnect-setup), which install all necessary dependencies and set up the project structure for you.

## Usage
The main entry of this application is through the `gui` module, where a graphical user interface (GUI) can be started by running:
```bash
$ python -m millconnect_client.gui
```

This will start the application and allows to select a project folder that contains the construction information for the orders you want to upload. After selecting a project, the application will open a browser where you can view the order and make adjustments if necessary. Once the user wants to send the order, the application will upload all necessary files to the backend server.

### Additional arguments
The `gui` module also accepts additional command line arguments and its signature is:
``` bash
gui.py [-h] [--host [HOST]] [--uploadURL [UPLOADURL]] [--no-update] [projectPath]
```
Here, `projectPath` is an optional argument that specifies the path to a project folder which automatically opens when starting the application. The other arguments are:
- `-h, --help`: show the help message and exit
- `--host [HOST]`: The URL of the backend server, e.g. `https://api.connect.millhouse.local/v1`.
- `--uploadURL [UPLOADURL]`: The URL of the frontend to open in the browser, e.g. `https://connect.millhouse.de/uploadOrder`.
- `--no-update`: Do not check for updates.

## Development
While this project contains a `.devcontainter` configuration, the development should be done using virtual environments to use the GUI. To do so, follow these steps:
```bash
$ python3 -m venv env  # Create a new Python environment
$ source env/bin/activate  # Activate it
(env) $ pip install -r requirements.txt   # Install the dependencies
```

For convenience, the script `utils/execute` can be used to start with the right arguments of the local development servers.