import unittest
import asyncio

from pathlib import Path
import sys
import logging
logging.basicConfig(stream=sys.stdout, level=logging.INFO, format='%(asctime)s %(name)s %(levelname)s: %(message)s')
logger = logging.getLogger(__name__)

from src.millconnect.project import Project
from src.millconnect.server import listen, sendProject, awaitNewOrder, confirmNewOrder, handleConnection

class ServerTest(unittest.IsolatedAsyncioTestCase):

    async def test_sendOrder(self):
        async def handleOrderCreation(websocket, running):

            project = Project(Path('tests/samples/86208'))

            await sendProject(websocket, project)

            running.set_result(False)


        while True:
            running = asyncio.get_running_loop().create_future()
            server = await listen('localhost', 8765, lambda x: handleOrderCreation(x, running))
            logger.info('Started server')

            try:
                await running
                server.close()
            except KeyboardInterrupt:
                break

    async def test_createOrder(self):
        async def handleOrderCreation(websocket, running):

            project = Project(Path('tests/samples/86208'))

            await sendProject(websocket, project)
            confirmedOrder = await awaitNewOrder(websocket)
            project.update(confirmedOrder['order'])
            await confirmNewOrder(websocket)

        while True:
            running = asyncio.get_running_loop().create_future()
            server = await listen('localhost', 8765, lambda x: handleOrderCreation(x, running))
            logger.info('Started server')

            try:
                await running
                server.close()
            except KeyboardInterrupt:
                break
