import unittest
from unittest import mock

from src.millconnect import updater

class UpdaterTest(unittest.TestCase):

    @mock.patch('os.execv')
    @mock.patch('sys.argv')
    def test_restart_with_spaces(self, argv: mock.Mock, execv: mock.Mock):
        argv.return_value = ['python -m millconnect.gui', r'c:\some path\ with space\folder']

        updater.restartIntoNewApplication()

        for arg in execv.call_args[0][1]:
            self.assertTrue(arg.startswith('"') and arg.endswith('"'))