import unittest
import asyncio

from pathlib import Path
import sys
import logging
logging.basicConfig(stream=sys.stdout, level=logging.INFO, format='%(asctime)s %(name)s %(levelname)s: %(message)s')
logger = logging.getLogger(__name__)

from src.millconnect.project import Project
from src.millconnect.server import listen, handleConnection

class ZahnomatTest(unittest.IsolatedAsyncioTestCase):
    async def test_handleConnection(self):
        availableHost = 'http://zahnomat-backend:8000'

        project = Project(Path('tests/samples/02_Krone/156094_krone_inkl_Abutment'))

        while True:

            running = asyncio.get_running_loop().create_future()
            server = await listen('localhost', 8765, lambda x: handleConnection(x, project, availableHost, running))
            logger.info('Started server')

            try:
                await running
                server.close()
            except KeyboardInterrupt:
                break